/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.TransportCategory;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNpcTransporter
extends GuiNPCInterface2
implements IScrollData,
IGuiData {
    private final HashMap<String, Integer> data = new HashMap();
    public TransportLocation location = new TransportLocation();
    private GuiCustomScroll scroll;

    public GuiNpcTransporter(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 0) {
            this.location.type = button.getValue();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.scroll != null) {
            if (this.getTextField(0) != null) {
                this.getTextField(0).setIsVisible(this.scroll.hasSelected());
            }
            if (this.getButton(0) != null) {
                this.getButton(0).setIsVisible(this.scroll.hasSelected());
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(143, 196);
        }
        int x = this.guiLeft + 6;
        int y = this.guiTop + 16;
        this.scroll.guiLeft = x;
        this.scroll.guiTop = y;
        this.addScroll(this.scroll);
        this.addLabel(new GuiNpcLabel(0, "gui.categories", x + 2, y - 11));
        this.addLabel(new GuiNpcLabel(1, "gui.name", x += 147, y - 11));
        GuiNpcTextField textField = new GuiNpcTextField(0, this, this.field_146289_q, x, y, 140, 20, this.location.name);
        textField.setHoverText("manager.hover.transport.loc.name", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(0, x, y + 24, new String[]{"transporter.discovered", "transporter.start", "transporter.interaction"}, this.location.type);
        button.setHoverText(new TextComponentTranslation("manager.hover.transport.type", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("manager.hover.transport.addinfo", new Object[0])).func_150254_d(), new Object[0]);
        this.add(button);
    }

    @Override
    public void initPacket() {
        Client.sendData(EnumPacketServer.TransportCategoriesGet, -1);
        Client.sendData(EnumPacketServer.TransportGetLocation, new Object[0]);
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 1) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
    }

    @Override
    public void save() {
        if (!this.scroll.hasSelected()) {
            return;
        }
        String name = this.getTextField(0).getFullText();
        if (!name.isEmpty()) {
            this.location.name = name;
        }
        this.location.pos = new BlockPos((Entity)this.player);
        this.location.dimension = this.player.field_71093_bK;
        try {
            this.location.npc = this.npc.func_110124_au();
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        int cat = this.data.get(this.scroll.getSelected());
        Client.sendData(EnumPacketServer.TransportSave, cat, this.location.writeNBT());
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> dataMap) {
        this.data.clear();
        this.data.putAll(dataMap);
        Collections.sort(list);
        this.scroll.setListNotSorted(list);
        TextComponentTranslation l = new TextComponentTranslation("gui.localization", new Object[0]);
        TextComponentTranslation p = new TextComponentTranslation("gui.points", new Object[0]);
        l.func_150256_b().func_150238_a(TextFormatting.GRAY);
        p.func_150256_b().func_150238_a(TextFormatting.GRAY);
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        for (String str : list) {
            StringBuilder hover = new StringBuilder();
            TransportCategory cat = TransportController.getInstance().categories.get(this.data.get(str));
            if (cat != null && !cat.locations.isEmpty()) {
                for (int id : cat.locations.keySet()) {
                    if (hover.length() > 0) {
                        hover.append(";<br>");
                    }
                    hover.append("\u00a77ID: \u00a7r").append(id).append('\u00a7').append("7 \"").append('\u00a7').append("r").append(new TextComponentTranslation(cat.locations.get((Object)Integer.valueOf((int)id)).name, new Object[0]).func_150254_d()).append('\u00a7').append("7\"");
                }
                hover.insert(0, p.func_150254_d() + "<br>");
            }
            hts.put(i++, Arrays.asList(hover.toString().split("<br>")));
        }
        this.scroll.setHoverTexts(hts);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_150296_c().isEmpty()) {
            return;
        }
        TransportLocation loc = new TransportLocation();
        loc.readNBT(compound);
        this.location = loc;
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
        this.scroll.setSelected(selected);
    }
}

